/*******************************************************************************
 * Copyright (c) 2022, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework;

/**
 * Gateway Framework.
 * <p>
 * A {@link GatewayApplication} introduces itself to the framework using the
 * {@link DiffusionGatewayFramework#start}
 * method which returns a reference of this type that the application can use to
 * get overall configuration of the application during runtime, if required.
 *
 * @author DiffusionData Limited
 */
public interface GatewayFramework {
    /**
     * Returns the full configuration for the declared gateway application.
     * <p>
     * The source of configuration can be either a configuration file or the
     * Diffusion server, depending on the bootstrap configuration supplied
     * when starting the application.
     * <p>
     * The configuration is updated whenever a service is added, updated or
     * removed. This method returns the current state of the configuration.
     *
     * @return full configuration for the application, or null if called before
     *         a successful connection to the Diffusion server
     */
    String getConfiguration();
}
