/*******************************************************************************
 * Copyright (c) 2022, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework;

import com.diffusiondata.gateway.framework.converters.PayloadConverter;

/**
 * The interface that a hybrid handler must implement.
 * <p>
 * A hybrid handler is a combination of a {@link SinkHandler sink handler} (in
 * that it can receive updates from Diffusion topics) and a
 * {@link StreamingSourceHandler streaming source handler} (in that it can also
 * publish updates back to Diffusion topics). It extends both of these
 * interfaces.
 * <p>
 * This type of service is especially useful for transforming data received from
 * Diffusion topics and feeding the transformed data back to other Diffusion
 * topics and may have many uses. It does not necessarily have to interact with
 * any back end system.
 * <p>
 * A hybrid handler receives updates from the framework via its {@link #update
 * update} method. A hybrid handler will only receive updates when the service
 * is in an {@link ServiceState#ACTIVE ACTIVE} state.
 * <p>
 * A hybrid handler will not receive updates until the
 * {@link ServiceHandler#start start} method has been called. It will also not
 * receive updates if the {@link ServiceHandler#pause pause} method has been
 * called and updates will not resume until the {@link ServiceHandler#resume
 * resume} method is called. The handler should also not publish updates to
 * Diffusion via the {@link Publisher} until the start method has been called or
 * when it has been paused or stopped.
 * <p>
 * An object that implements this interface must be returned when the
 * {@link GatewayApplication#addHybrid GatewayApplication.addHybrid} method is
 * called. A different object must be returned for each different service. The
 * object must implement the {@link #update update} method to receive updates
 * from Diffusion.
 * <p>
 * The handler may also optionally return both {@link SinkServiceProperties sink
 * service specific properties} via its
 * {@link SinkHandler#getSinkServiceProperties} method, and
 * {@link SourceServiceProperties source service specific properties} via its
 * {@link SourceHandler#getSourceServiceProperties} method. If it does not then
 * defaults will be assumed.
 *
 * @param <T> the type of object that is expected by the {@link #update} method.
 *        This should match the type that is output by the
 *        {@link PayloadConverter payload converter} in use for the
 *        service.
 *
 * @author DiffusionData Limited
 */
public interface HybridHandler<T>
    extends SinkHandler<T>, StreamingSourceHandler {
}