/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework;

/**
 * Indicates the current state of a service.
 * <p>
 * A {@link SourceHandler} or {@link HybridHandler} can only publish updates,
 * and a {@link SinkHandler} or {@link HybridHandler} will only receive updates
 * when the service state is {@link #ACTIVE}.
 *
 * @author DiffusionData Limited
 */
public enum ServiceState {

    /**
     * This is the initial state of a service before the
     * {@link ServiceHandler#start} method has been called.
     */
    INITIAL,

    /**
     * This is the state when a service has been successfully
     * {@link ServiceHandler#start started} or {@link ServiceHandler#resume
     * resumed}.
     */
    ACTIVE,

    /**
     * This is the state when a service has been {@link ServiceHandler#pause
     * paused} by user request, the framework has become disconnected from the
     * Diffusion, or the service handler has reported an error.
     */
    PAUSED,

    /**
     * This is the state when the application has been stopped or the service
     * has been removed.
     * <p>
     * This is the terminal state for a service. It can no longer be started or
     * resumed.
     */
    STOPPED
}