/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework;

/**
 * A sharedConfig type.
 * <p>
 * An application that uses sharedConfigs can define one or more sharedConfig types,
 * each having its own schema defining the parameters to the sharedConfig.
 * <p>
 * Any number of sharedConfig types can be defined providing different
 * schemas for sharedConfig parameters.
 * <p>
 * SharedConfig types are declared by a {@link GatewayApplication} via its
 * {@link GatewayApplication#getApplicationDetails getApplicationDetails}
 * method.
 *
 * @author DiffusionData Limited
 */
public interface SharedConfigType {

    /**
     * Return the sharedConfig type name.
     * <p>
     * This is the name that any configured sharedConfig must provide in order to
     * specify its parameters.
     *
     * @return the sharedConfig type name
     */
    String getName();

    /**
     * Returns the sharedConfig type's description.
     *
     * <p>
     * The description defines the sharedConfig type so that users understand
     * what the sharedConfig type is for.
     * @return description of the service type.
     */
    String getDescription();

    /**
     * Returns the sharedConfig type's JSON schema.
     * <p>
     * The schema defines the format of the application specific parameters that
     * may be configured for a sharedConfig of this type.
     *
     * @return schema
     */
    String getSchema();
}