/*******************************************************************************
 * Copyright (c) 2022, 2024 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework;

import com.pushtechnology.diffusion.datatype.binary.Binary;

/**
 * Specifies a Diffusion topic type.
 *
 * @author DiffusionData Limited
 */
public enum TopicType {

    /**
     * The topic holds values in JSON format.
     * <p>
     * For efficiency the data is actually held in
     * <a href="https://cbor.io">CBOR</a> (Concise Binary Object Representation)
     * format and values are presented by the Diffusion
     * {@link com.pushtechnology.diffusion.datatype.json.JSON JSON} type.
     * <p>
     * This is the most flexible type of topic that leverages all of the
     * Diffusion in-server transformation capabilities.
     */
    JSON(com.pushtechnology.diffusion.datatype.json.JSON.class),

    /**
     * The topic holds values in {java.lang.String String} format.
     */
    STRING(String.class),

    /**
     * The topic holds values in raw binary format.
     */
    BINARY(Binary.class),

    /**
     * The topic holds a 64 bit integer.
     * <p>
     * This equates to {@link java.lang.Long}.
     */
    INT64(Long.class),

    /**
     * The topic holds a double precision floating point number.
     * <p>
     * This equates to {@link java.lang.Double}.
     */
    DOUBLE(Double.class);

    private final Class<?> clazz;

    TopicType(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Class<?> getDataType() {
        return clazz;
    }
}