/*******************************************************************************
 * Copyright (c) 2022, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
/**
 * <H1>Payload Converters.</H1>
 * <p>
 * A payload converter provides conversion or transformation of values.
 * It takes an input value, performs required manipulation and returns
 * an output value, which can be of same or different format.
 * <p>
 * Payload converters may be specified for services within the
 * {@link com.diffusiondata.gateway.framework.SourceHandler.SourceServiceProperties}
 * for source services or
 * {@link com.diffusiondata.gateway.framework.SinkHandler.SinkServiceProperties}
 * for sink services.
 * <p>
 * The payload converter specified in the source service should convert the input value
 * into a Diffusion topic type.
 * In this case, values from an external system are passed to a
 * {@link com.diffusiondata.gateway.framework.Publisher Publisher} within a
 * {@link com.diffusiondata.gateway.framework.SourceHandler SourceHandler} or
 * {@link com.diffusiondata.gateway.framework.HybridHandler HybridHandler} and
 * is converted into specific Diffusion topic type using the converter.
 * <p>
 * The payload converter specified in the sink service should convert the value
 * from the Diffusion topic type.
 * In this case, the converter converts values from a Diffusion data type
 * to an external data type before passing values to a
 * {@link com.diffusiondata.gateway.framework.SinkHandler SinkHandler} via
 * its {@link com.diffusiondata.gateway.framework.SinkHandler#update update}
 * method, or to a {@link com.diffusiondata.gateway.framework.HybridHandler
 * HybridHandler} via its {@link com.diffusiondata.gateway.framework.HybridHandler#update update}
 * method.
 * <br>
 * <H2>Payload converters for topic types</H2> If a payload converter is not specified
 * within the service property, a topic type must be specified in which case a
 * default converter for the topic type will be used. Default conversions are shown in the tables
 * below.<br>
 * <br>
 * <table border="1">
 * <caption><b>Default Conversions for Source service</b></caption>
 * <tr>
 * <th>{@link com.diffusiondata.gateway.framework.TopicType Topic Type}</th>
 * <th>Converter name</th>
 * <th>Description</th>
 * <tr>
 * <td>{@link com.diffusiondata.gateway.framework.TopicType#BINARY BINARY}</td>
 * <td>{@value com.diffusiondata.gateway.framework.converters.PayloadConverter#OBJECT_TO_BINARY_TOPIC}</td>
 * <td>If the value is an instance of
 * {@link com.pushtechnology.diffusion.datatype.binary.Binary Binary}, it is
 * returned as is.<br>
 * If the value is a byte[], it will be converted to a
 * {@link com.pushtechnology.diffusion.datatype.binary.Binary Binary} object.
 * The caller must not write further data to the array.<br>
 * All other types will throw a
 * {@link com.diffusiondata.gateway.framework.exceptions.PayloadConversionException
 * PayloadConversionException}.</td>
 * </tr>
 * <tr>
 * <td>{@link com.diffusiondata.gateway.framework.TopicType#DOUBLE DOUBLE}</td>
 * <td>{@value com.diffusiondata.gateway.framework.converters.PayloadConverter#OBJECT_TO_DOUBLE}</td>
 * <td>If the value is an instance of {@link Double}, it is returned as is.<br>
 * If the value is an instance of {@link Number}, the product of its
 * {@link Number#doubleValue doubleValue} method is returned.<br>
 * If the value is null, null will be returned (leading to a null topic
 * value}.<br>
 * For any other type the {@link Double#parseDouble} method is used on the
 * {@link Object#toString toString} value of the supplied value and if the
 * string value cannot be parsed as a double, a
 * {@link com.diffusiondata.gateway.framework.exceptions.PayloadConversionException
 * PayloadConversionException} will be thrown.</td>
 * </tr>
 * <tr>
 * <td>{@link com.diffusiondata.gateway.framework.TopicType#INT64 INT64}</td>
 * <td>{@value com.diffusiondata.gateway.framework.converters.PayloadConverter#OBJECT_TO_LONG}</td>
 * <td>If the value is an instance of {@link Long}, it is returned as is.<br>
 * If the value is an instance of {@link java.lang.Number Number}, the product
 * of its {@link java.lang.Number#longValue longValue} method is returned.<br>
 * If the value is null, null will be returned (leading to a null topic
 * value}.<br>
 * For any other type the {@link java.lang.Long#parseLong parseLong} method is
 * used on the {@link java.lang.Object#toString toString} value of the supplied
 * value and if the string value cannot be parsed as a long, a
 * {@link com.diffusiondata.gateway.framework.exceptions.PayloadConversionException
 * PayloadConversionException} will be thrown.</td>
 * <tr>
 * <td>{@link com.diffusiondata.gateway.framework.TopicType#JSON JSON}</td>
 * <td>{@value com.diffusiondata.gateway.framework.converters.PayloadConverter#OBJECT_TO_JSON}</td>
 * <td>If the value is an instance of
 * {@link com.pushtechnology.diffusion.datatype.json.JSON JSON}, it is returned
 * as is.<br>
 * If a null value is passed, JSON containing "null" will be returned.<br>
 * Otherwise the input object will be converted to
 * a {@link com.pushtechnology.diffusion.datatype.json.JSON JSON} object.
 * Supported types of input objects are basic POJOs, primitives, and collections
 * such as Map and List.<br>
 * If the input value does not contain valid JSON, a
 * {@link com.diffusiondata.gateway.framework.exceptions.PayloadConversionException
 * PayloadConversionException} is thrown.</td>
 * </tr>
 * <tr>
 * <td>{@link com.diffusiondata.gateway.framework.TopicType#STRING STRING}</td>
 * <td>{@value com.diffusiondata.gateway.framework.converters.PayloadConverter#OBJECT_TO_STRING}</td>
 * <td>If the value is null, null is returned (leading to a null topic
 * value).<br>
 * If the value is a {@link java.lang.String String} it is returned as is.<br>
 * For any other type the product of its {@link java.lang.Object#toString
 * toString} method is returned.</td>
 * </tr>
 * </table>
 * <br>
 * <table border="1">
 * <caption><b>Default Conversions for Sink service</b></caption>
 * <tr>
 * <th>{@link com.diffusiondata.gateway.framework.TopicType Topic Type}</th>
 * <th>Converter name</th>
 * <th>Description</th>
 * <tr>
 * <td>{@link com.diffusiondata.gateway.framework.TopicType#BINARY BINARY}</td>
 * <td>{@value com.diffusiondata.gateway.framework.converters.PayloadConverter#BINARY_TOPIC_TO_BYTE_ARRAY}</td>
 * <td>A byte[] representation of the topic's
 * {@link com.pushtechnology.diffusion.datatype.binary.Binary Binary} value is
 * returned. This is a byte[] view of the actual value and as such must not be
 * modified.</td>
 * </tr>
 * <tr>
 * <td>{@link com.diffusiondata.gateway.framework.TopicType#JSON JSON}</td>
 * <td>{@value com.diffusiondata.gateway.framework.converters.PayloadConverter#JSON_TO_STRING}</td>
 * <td>A {@link java.lang.String String} is returned which contains the string
 * representation of the JSON object.</td>
 * </tr>
 * </table>
 * <p>
 * Apart from these converters for Diffusion topic types, there
 * are other converters issued with the framework. See the user guide for
 * more details
 * <H2>Writing a Payload Converter</H2>
 * <p>
 * A payload converter must implement {@link com.diffusiondata.gateway.framework.converters.PayloadConverter} interface.
 * <p>
 * The input or output type of the converter can be anything that could also be the Diffusion topic type to which the
 * service will be mapped.
 * <br>
 * The Diffusion <code>com.pushtechnology.diffusion.datatype package</code>
 * (described within the Diffusion Client API) should be used for reading and
 * writing Diffusion values.
 * <br>
 * <h3>Writing Configurable Payload Converters</h3>
 * An application user can configure payload converters to be used for a service.
 * To enable configuration for a converter, it must be written in a specific way, as explained below.
 * <ol>
 *     <li>The converter must be public.</li>
 *     <li>A payload converter can be referred to in the configuration using its name.
 *     By default, the name of the converter is the simple name of the implemented class.
 *     This can be overridden by specifying a public static method called <b>getName</b>.
 *     The name should not start with a '$' character, as this character is reserved for
 *     converters provided by DiffusionData.</li>
 *     <li>If a payload converter requires construction parameters, a public constructor
 *     must be declared that accepts a Map.
 *     The key and value of the map must be the name of a parameter and its value, respectively.
 *     The value can be of a primitive type, a list of primitives, or a map of primitives.</li>
 * </ol>
 * If converter configuration is specified in the service configuration or in the service properties of a
 * {@link com.diffusiondata.gateway.framework.ServiceHandler}, the converter instance is instantiated by the framework.
 * Converters that require construction parameters are instantiated by calling their
 * constructor with user-configured parameters.
 * <p>
 * Payload converters are called in line when publishing or updating and so must
 * operate synchronously. However, there is no reason why a converter should not
 * call out to some external service to perform a conversion as long as it
 * blocks awaiting the response.
 *
 * @author DiffusionData Limited
 */
package com.diffusiondata.gateway.framework.converters;
