/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework.exceptions;

/**
 * Indicates that a failure was detected when initializing a gateway
 * application.
 * <p>
 * This is possibly because of a failure to validate the application or its
 * configuration.
 *
 * @author DiffusionData Limited
 */
public final class ApplicationInitializationException
    extends GatewayFrameworkException {

    private static final long serialVersionUID = -4016452092791119748L;

    /**
     * Constructor.
     *
     * @param message the detail message
     */
    public ApplicationInitializationException(String message) {
        super(message);
    }

    /**
     * Constructor.
     *
     * @param message the detail message
     *
     * @param cause the cause of the failure
     */
    public ApplicationInitializationException(String message, Throwable cause) {
        super(message, cause);
    }

}
