/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework.exceptions;

/**
 * Indicates that the framework application principal does not have sufficient
 * permissions to perform the operation.
 *
 * @author DiffusionData Limited
 */
public final class DiffusionSecurityException extends DiffusionClientException {

    private static final long serialVersionUID = 7017701211763891554L;

    /**
     * Constructor.
     *
     * @param message the detail message
     *
     * @param cause the cause which will be an exception as defined by the
     *        Diffusion Client API.
     */
    public DiffusionSecurityException(String message, Throwable cause) {
        super(message, cause);
    }

}
