/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework.exceptions;

import com.diffusiondata.gateway.framework.converters.PayloadConverter;

/**
 * Indicates a failure to perform a {@link PayloadConverter} operation.
 *
 * @author DiffusionData Limited
 */
public final class PayloadConversionException
    extends GatewayApplicationException {

    private static final long serialVersionUID = 7217025521242234809L;

    /**
     * Constructor.
     *
     * @param message the error message
     *
     * @param cause the cause of the exception
     */
    public PayloadConversionException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor.
     *
     * @param message the error message
     */
    public PayloadConversionException(String message) {
        super(message);
    }
}