/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework;

/**
 * A service type.
 * <p>
 * A service type defines a type of service that the application supports. Any
 * number of instances of service of the same type may be instantiated with
 * differing parameters.
 * <p>
 * An application can define any number of service types, each having its own
 * schema defining the parameters to the service.
 * <p>
 * An application must define at least one service type, but any number can be
 * defined providing different schemas for service parameters.
 * <p>
 * Service types are declared by a {@link GatewayApplication} via its
 * {@link GatewayApplication#getApplicationDetails getApplicationDetails}
 * method.
 *
 * @author DiffusionData Limited
 */
public interface ServiceType {
    /**
     * Returns the service type name.
     * <p>
     * Every configured service must specify a service type name that identifies
     * the type of service.
     *
     * @return service type name
     */
    String getName();

    /**
     * Returns the service mode.
     * <p>
     * Indicates the {@link ServiceMode mode} of services of this type.
     *
     * @return the service mode
     */
    ServiceMode getMode();

    /**
     * Returns the service type's description.
     *
     * <p>
     * The description defines the service type so that users understand
     * what the service type will do.
     * @return description of the service type.
     */
    String getDescription();

    /**
     * Returns the service type's JSON schema.
     * <p>
     * The schema defines the format of the application specific parameters that
     * may be configured for a service of this type.
     *
     * @return schema
     */
    String getSchema();
}