@echo off

setlocal
cd /d %~dp0

if not defined ADAPTER_HOME (
  set ADAPTER_HOME=..
)

rem Configure Log4j.
if not defined LOG4J_CONFIGURATION (
   set "LOG4J_CONFIGURATION= -Dlog4j.configurationFile=%ADAPTER_HOME%\etc\log4j2.xml"
)

rem Specify the location for JVM diagnostic output.
if not defined JVM_LOG_DIR (
   set JVM_LOG_DIR=%ADAPTER_HOME%\logs
)

rem Enable G1 garbage collector.
if not defined ENABLE_GC_G1 (
  set "ENABLE_GC_G1= -XX:+UseG1GC"
)

rem Enable AlwaysPreTouch, which helps the OS pre-assign all memory
rem pages. This may delay JVM start up with a large heap.
if not defined ENABLE_JAVA_PRETOUCH (
  set "ENABLE_JAVA_PRETOUCH= -XX:+AlwaysPreTouch"
)

rem ##############################
rem Uncomment subsequent lines to enable the behavior specified in the
rem description. This should be justified on a case by case basis.
rem Test with the expected workload before doing so in production
rem environment.

rem Define your heap size based on your deployment needs. Replace NNN
rem with your requirement.
rem set "JAVA_HEAP_OPTS= -XmsNNNg -XmxNNNg"

rem Enable logging of safepoint pause time information
rem NOTE: this prints to StdOut as well as the 'LogFile' so it can be
rem       quite verbose in the adapter log.
rem set "ENABLE_SAFEPOINT_LOG= -XX:+PrintSafepointStatistics -XX:PrintSafepointStatisticsCount=1 -XX:+LogVMOutput -XX:LogFile=%JVM_LOG_DIR%\safepoint.log"

rem Enables Java Flight Recorder(JFR), a tool for collecting
rem diagnostic and profiling data from the JVM.
rem NOTE: JFR may require a commercial license for use in production.
rem       Please make sure you understand the licensing requirements.
rem set "ENABLE_JFR= -XX:+UnlockCommercialFeatures -XX:+DebugNonSafepoints -XX:+FlightRecorder -XX:StartFlightRecording=dumponexit=true,filename=%JVM_LOG_DIR%\adapter-recording.jfr,maxsize=512m,maxage=1d"

rem Enables verbose GC logging for detailed analysis of heap behavior.
rem set "ENABLE_GC_LOG= -verbose:gc -XX:+PrintGC -XX:+PrintGCDetails -XX:+PrintGCApplicationConcurrentTime -XX:+PrintGCApplicationStoppedTime -XX:+PrintGCTimeStamps -XX:+PrintGCDateStamps -Xloggc:%JVM_LOG_DIR%\verbosegc.log -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=10 -XX:GCLogFileSize=100M"

rem Allow external tracing (profiling) tools to construct more accurate stack traces.
rem set "PRESERVE_FRAME_POINTER= -XX:+PreserveFramePointer"

rem Open parameter for miscellaneous Java options.
rem set EXTRA_JAVA_OPTIONS=

rem ###############################
rem Edit the configuration below as required
rem See https://download.diffusiondata.com/gateway-framework/latest/user-guide/contents/configuration/bootstrap-configuration.html for details on bootstrap configuration
java -XX:+HeapDumpOnOutOfMemoryError^
 -XX:HeapDumpPath=%JVM_LOG_DIR%^
 -XX:ErrorFile=%JVM_LOG_DIR%\hs_err_pid_%p.log^
 -XX:+UnlockDiagnosticVMOptions^
 %JAVA_HEAP_OPTS%^
 %ENABLE_JAVA_PRETOUCH%^
 %ENABLE_GC_LOG%^
 %ENABLE_SAFEPOINT_LOG%^
 %ENABLE_JFR%^
 %PRESERVE_FRAME_POINTER%^
 %ENABLE_GC_G1%^
 %LOG4J_CONFIGURATION%^
 -Dgateway.diffusion.url="ws://localhost:8080"^
 -Dgateway.diffusion.principal="admin"^
 -Dgateway.diffusion.password="password"^
 -Dgateway.client.id="kafka-adapter-1"^
 -Dgateway.config.use-local-services="false"^
 -Dgateway.config.auto-save-to-file="false"^
 -Dadapter.home="%ADAPTER_HOME%"^
 -Dgateway.ext.dir="ext"^
 %EXTRA_JAVA_OPTIONS%^
 %*^
 -jar %ADAPTER_HOME%\lib\diffusion-adapter-1.1.0.jar

endlocal
