/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework;

/**
 * Service mode of operation.
 * <p>
 * This defines the mode of operation for a service.
 *
 * @author DiffusionData Limited
 */
public enum ServiceMode {

    /**
     * Indicates that a service is a streaming source service that consumes
     * streaming data from a back end source and publishes it to Diffusion.
     * <p>
     * Such a service is implemented by a {@link StreamingSourceHandler}.
     */
    STREAMING_SOURCE(
        "A streaming source service that consumes streaming data from a back " +
            "end source and publishes it to Diffusion."),

    /**
     * Indicates that a service is a polling source service that is periodically
     * polled by the framework for updates which are then published to
     * Diffusion.
     * <p>
     * Such a service is implemented by a {@link PollingSourceHandler}.
     */
    POLLING_SOURCE(
        "A polling source service that is periodically polled by the " +
            "framework for updates which are then published to Diffusion."),

    /**
     * Indicates that a service is a sink service that consumes data from
     * Diffusion and publishes it to a back end data sink.
     * <p>
     * Such a service is implemented by a {@link SinkHandler}.
     */
    SINK(
        "A sink service that consumes data from Diffusion and publishes it to" +
            " a back end data sink."),

    /**
     * Indicates that a service is a hybrid service that both consumes data from
     * Diffusion and publishes data to Diffusion.
     * <p>
     * This type of service may be used to transform data consumed from
     * Diffusion topics and publish back to different Diffusion topics.
     * <p>
     * Such a service is implemented by a {@link HybridHandler}.
     */
    HYBRID(
        "A hybrid service that both consumes data from Diffusion and " +
            "publishes data to Diffusion.");

    private final String description;

    /**
     * Constructor.
     */
    ServiceMode(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }
}