/*******************************************************************************
 * Copyright (c) 2024 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/

package com.diffusiondata.gateway.framework;

/**
 * A holder for the update context that contains the Gateway application-specific
 * update context, which can be used to process the update.
 * <p>
 * The context provided by different applications will vary. An
 * application that supports the {@link CustomPublisher} should implement this interface
 * to specify an update context that it supplies with the update. The custom
 * publisher for that application can then utilize the context as required.
 * <p>
 * The application's documentation should be consulted to understand if it supports
 * using a custom publisher and the {@link UpdateContext} it supplies with the update.
 *
 * @author DiffusionData Limited
 * @since 2.2
 */
public interface UpdateContext {

    /**
     * Returns the Diffusion topic that would be published to if the custom
     * publisher was not used.
     *
     * @return the Diffusion topic that would be published to if the custom
     *     publisher was not used
     */
    String getDiffusionTopic();

    /**
     * Returns the topic properties that would have been used for the Diffusion
     * topic.
     *
     * @return the topic properties that would have been used for the Diffusion
     *     topic
     */
    TopicProperties getTopicProperties();
}
