#!/bin/sh

DIR=$(dirname "$0"); cd "$DIR" || exit
ADAPTER_HOME="${ADAPTER_HOME-..}"

# Configure Log4j.
LOG4J_CONFIGURATION=${LOG4J_CONFIGURATION- -Dlog4j.configurationFile="${ADAPTER_HOME}/etc/log4j2.xml"}

# Specify the location for JVM diagnostic output.
JVM_LOG_DIR=${JVM_LOG_DIR-${ADAPTER_HOME}/logs}

# Enable G1 garbage collector.
ENABLE_GC_G1=${ENABLE_GC_G1- -XX:+UseG1GC}

# Enable AlwaysPreTouch, which helps the OS pre-assign all memory
# pages. This may delay JVM start up with a large heap.
ENABLE_JAVA_PRETOUCH=${ENABLE_JAVA_PRETOUCH- -XX:+AlwaysPreTouch}

###############################
# Uncomment subsequent lines to enable the behavior specified in the
# description. This should be justified on a case by case basis.
# Test with the expected workload before doing so in production
# environment.

# Define your heap size based on your deployment needs. Uncomment and
# replace NNN with your requirement.
#JAVA_HEAP_OPTS=${JAVA_HEAP_OPTS- -XmsNNNg -XmxNNNg}

# Enable logging of safepoint pause time information
# NOTE: this prints to stdout as well as the 'LogFile' so it can be
#       quite verbose in the adapter log.
#ENABLE_SAFEPOINT_LOG=${ENABLE_SAFEPOINT_LOG- -XX:+PrintSafepointStatistics -XX:PrintSafepointStatisticsCount=1 -XX:+LogVMOutput -XX:LogFile=${JVM_LOG_DIR}/safepoint.log}

# Enable Java Flight Recorder(JFR), a tool for collecting diagnostic
# and profiling data from the JVM.
# NOTE: JFR may require a commercial license for use in production.
#       Please make sure you understand the licensing requirements.
#ENABLE_JFR=${ENABLE_JFR- -XX:+UnlockCommercialFeatures -XX:+DebugNonSafepoints -XX:+FlightRecorder -XX:StartFlightRecording=dumponexit=true,filename=${JVM_LOG_DIR}/adapter-recording.jfr,maxsize=512m,maxage=1d}

# Enable verbose GC logging for detailed analysis of heap behavior.
#ENABLE_GC_LOG=${ENABLE_GC_LOG- -verbose:gc -XX:+PrintGC -XX:+PrintGCDetails -XX:+PrintGCApplicationConcurrentTime -XX:+PrintGCApplicationStoppedTime -XX:+PrintGCTimeStamps -XX:+PrintGCDateStamps -Xloggc:${JVM_LOG_DIR}/verbosegc.log -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=10 -XX:GCLogFileSize=100M}

# Allow external tracing (profiling) tools to construct more accurate stack traces.
#PRESERVE_FRAME_POINTER=${PRESERVE_FRAME_POINTER- -XX:+PreserveFramePointer}

# Open parameter for miscellaneous Java options.
#EXTRA_JAVA_OPTIONS=${EXTRA_JAVA_OPTIONS-}

###############################

# Edit the configuration below as required
# See https://download.diffusiondata.com/gateway-framework/latest/user-guide/contents/configuration/bootstrap-configuration.html for details on available bootstrap configuration
java -XX:+HeapDumpOnOutOfMemoryError\
 -XX:HeapDumpPath="${JVM_LOG_DIR}"\
 -XX:ErrorFile="${JVM_LOG_DIR}/hs_err_pid%p.log"\
 -XX:+UnlockDiagnosticVMOptions\
 ${JAVA_HEAP_OPTS}\
 ${ENABLE_JAVA_PRETOUCH}\
 ${ENABLE_GC_LOG}\
 ${ENABLE_SAFEPOINT_LOG}\
 ${ENABLE_JFR}\
 ${PRESERVE_FRAME_POINTER}\
 ${ENABLE_GC_G1}\
 ${LOG4J_CONFIGURATION}\
 -Dgateway.diffusion.url="ws://localhost:8080"\
 -Dgateway.diffusion.principal="admin"\
 -Dgateway.diffusion.password="password"\
 -Dgateway.client.id="kafka-adapter-1"\
 -Dgateway.config.use-local-services="false"\
 -Dgateway.config.auto-save-to-file="false"\
 -Dadapter.home="${ADAPTER_HOME}"\
 -Dgateway.ext.dir="ext"\
 ${EXTRA_JAVA_OPTIONS}\
 $@\
 -jar ${ADAPTER_HOME}/lib/kafka-adapter-2.4.0.jar
