/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework;

/**
 * The interface that a streaming source handler must implement.
 * <p>
 * A streaming source handler streams updates to Diffusion using the
 * {@link Publisher} provided to it when instantiated.
 * <p>
 * A streaming source handler must not publish updates on its {@link Publisher}
 * until the {@link ServiceHandler#start start} method has been called.
 * <p>
 * It must also stop publishing if the {@link ServiceHandler#pause pause} method
 * is called and not resume until the {@link ServiceHandler#resume resume}
 * method is called.
 * <p>
 * An object that implements this interface must be returned when the
 * {@link GatewayApplication#addStreamingSource
 * GatewayApplication.addStreamingSource} method is called. A different object
 * must be returned for each different service.
 *
 * @author DiffusionData Limited
 */
public interface StreamingSourceHandler extends SourceHandler {
}