/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework.exceptions;

/**
 * Indicates that the configuration of the application is invalid or the
 * application failed to be initialized due to configuration issues.
 *
 * @author DiffusionData Limited
 */
public final class ApplicationConfigurationException
    extends GatewayFrameworkException {

    private static final long serialVersionUID = 791961336550695866L;

    /**
     * Constructor.
     *
     * @param message the detail message
     */
    public ApplicationConfigurationException(String message) {
        super(message);
    }

    /**
     * Constructor.
     *
     * @param message the detail message
     *
     * @param cause the cause of the failure
     */
    public ApplicationConfigurationException(String message, Throwable cause) {
        super(message, cause);
    }

}
