/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework.exceptions;

/**
 * Indicates that an exception has been returned from the Diffusion Client API.
 * <p>
 * The cause will be the actual Diffusion Client API exception.
 *
 * @author DiffusionData Limited
 */
public class DiffusionClientException extends GatewayFrameworkException {

    private static final long serialVersionUID = 2296747780480884175L;

    /**
     * Constructor.
     *
     * @param message the detail message
     *
     * @param cause the cause which will be an exception as defined by the
     *        Diffusion Client API.
     */
    public DiffusionClientException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor.
     *
     * @param message the detail message
     */
    public DiffusionClientException(String message) {
        super(message);
    }
}
