/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework.exceptions;

import com.diffusiondata.gateway.framework.GatewayApplication;

/**
 * A checked exception that can be thrown by a {@link GatewayApplication}.
 *
 * @author DiffusionData Limited
 */
public class GatewayApplicationException extends Exception {

    private static final long serialVersionUID = -7171468965543707756L;

    /**
     * Constructor.
     *
     * @param message the detail message
     * @param cause the cause
     */
    public GatewayApplicationException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor.
     *
     * @param message the detail message
     */
    public GatewayApplicationException(String message) {
        super(message);
    }

}
