/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework.exceptions;

import com.diffusiondata.gateway.framework.GatewayApplication;

/**
 * An unchecked exception returned to a {@link GatewayApplication} from the
 * Gateway Framework.
 *
 * @author DiffusionData Limited
 */
public abstract class GatewayFrameworkException extends RuntimeException {

    private static final long serialVersionUID = 4754332048974281086L;

    /**
     * Constructor.
     *
     * @param message the detail message
     * @param cause the cause
     */
    public GatewayFrameworkException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor.
     *
     * @param message the detail message
     */
    public GatewayFrameworkException(String message) {
        super(message);
    }

}
