-- Scan the keys matching the pattern,
-- @returns a Pair<cursor, List<Pair<Key, Type>>>

-- arguments
local cursor = ARGV[1]
local pattern = ARGV[2]
local count = ARGV[3]
local result = {}

-- SCAN
local scanResult = redis.call('SCAN', cursor, 'MATCH', pattern, 'COUNT', count)
cursor = scanResult[1]
local keys = scanResult[2]

-- Get key types
for _, key in ipairs(keys) do
  local keyType = redis.call('TYPE', key)
  table.insert(result, { key, keyType })
end

return { cursor, result }
