/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework.exceptions;

/**
 * Indicates that an attempt to apply a JSON patch to a Diffusion topic has
 * failed.
 * <p>
 * This may be for a number of reasons, such as an invalid patch being supplied
 * or the target topic not being compatible with JSON patching. The cause will
 * provide more detail.
 *
 * @author DiffusionData Limited
 */
public final class JSONPatchException extends DiffusionClientException {

    private static final long serialVersionUID = -1961651177786928099L;

    /**
     * Constructor.
     *
     * @param message the detail message
     *
     * @param cause the cause which will be an exception as defined by the
     *        Diffusion Client API.
     */
    public JSONPatchException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor.
     *
     * @param indexOfFailedOperation the index of the first operation of patch
     *        which failed
     */
    public JSONPatchException(Integer indexOfFailedOperation) {
        super("Applying patch failed for operation at index: " +
            indexOfFailedOperation);
    }
}
