/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework.exceptions;

import com.diffusiondata.gateway.framework.ServiceState;

/**
 * Indicates that the operation being attempted is incompatible with the current
 * service state.
 * <p>
 * The service state at the time of the exception can be obtained using the
 * {@link #getState} method.
 *
 * @author DiffusionData Limited
 */
public final class ServiceStateException extends GatewayFrameworkException {

    private static final long serialVersionUID = 8287531388233783064L;

    private final ServiceState theState;

    /**
     * Constructor.
     *
     * @param currentState - the current state of the service
     */
    public ServiceStateException(ServiceState currentState) {
        super("Attempted operation is incompatible with service state " +
            currentState);
        theState = currentState;
    }

    /**
     * Constructor.
     *
     * @param currentState - the current state of the service
     * @param message the detail message
     */
    public ServiceStateException(ServiceState currentState, String message) {
        super(message);
        theState = currentState;
    }

    /**
     * Returns the current service state.
     *
     * @return current service state
     */
    public ServiceState getState() {
        return theState;
    }
}
