/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework;

import java.util.Map;

/**
 * Notification that a session has made a subscription request using a selector
 * that does not match any topics.
 *
 * @author DiffusionData Limited
 */
public interface MissingTopicNotification {

    /**
     * Returns the session properties of the session that made the request.
     *
     * @return the session properties
     */
    Map<String, String> getSessionProperties();

    /**
     * Returns the topic path derived from the requested topic selector.
     *
     * @return the topic path
     */
    String getTopicPath();

    /**
     * Returns topicSelector string that triggered this notification.
     *
     * @return the topic selector string
     */
    String getTopicSelector();
}
