/*******************************************************************************
 * Copyright (c) 2022 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.diffusiondata.gateway.framework;

/**
 * The update mode describes the style of updating that should be used
 * when publishing to Diffusion.
 *
 * @author DiffusionData Limited
 */
public enum UpdateMode {

    /**
     * Simple Update Mode.
     * <p>
     * In this mode each publish will be a separate update of the topic
     * sending the full value to the server. This allows for normal
     * publishing and also applying patches to JSON topics.
     * <p>
     * The updates are sent <b>asynchronously</b> to server. If the
     * update fails with transient, retryable error, retry will be
     * performed with last value, set for the topic.
     */
    SIMPLE,

    /**
     * Simple synchronous Update Mode.
     * <p>
     * In this mode each publish will be a separate update of the topic
     * sending the full value to the server. This allows for normal
     * publishing and also applying patches to JSON topics.
     * <p>
     * The updates are sent <b>synchronously</b> to server. If the update
     * fails with transient, retryable error, retry will be performed.
     * Only after all retry attempts exhausts, successive update
     * will be published to server. Hence, this mode can be less
     * performant compared to others.
     */
    SIMPLE_SYNC,

    /**
     * Streaming Update Mode.
     * <p>
     * In this mode sending updates to the server takes advantage of the
     * Diffusion 'delta' capabilities so that only changes to the value
     * are sent to the server thus significantly reducing bandwidth.
     * <p>
     * The updates are sent <b>asynchronously</b> to server. If the
     * update fails with transient, retryable error, retry will be
     * performed with last value set to the update stream.
     * <p>
     * In this mode it is not possible to apply patches to JSON topics.
     */
    STREAMING
}